import { createClient } from "https://esm.sh/@supabase/supabase-js";

const supabaseUrl = "https://bmroymhdqqbzlubpfjvs.supabase.co";
const supabaseKey =
  "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImJtcm95bWhkcXFiemx1YnBmanZzIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NDU0NTc4MjMsImV4cCI6MjA2MTAzMzgyM30.k-Vcbza0LeYr9mtQXwD2gHkIys-kmU0uky6VJ0LMX3g";
const supabase = createClient(supabaseUrl, supabaseKey);

const BUCKET_NAME = "user-files"; // ✅ replace with your real bucket name

async function uploadFile() {
  const fileInput = document.getElementById("fileInput");
  const file = fileInput.files[0];
  if (!file) return alert("Please select a file.");

  const filePath = `${Date.now()}_${file.name}`;

  const { error } = await supabase.storage
    .from(BUCKET_NAME)
    .upload(filePath, file);

  if (error) {
    console.error("Upload error:", error.message);
    alert("Upload failed.");
  } else {
    alert("File uploaded successfully!");
    listFiles();
  }
}

async function listFiles() {
  const { data, error } = await supabase.storage
    .from(BUCKET_NAME)
    .list("", { limit: 100 });

  const fileList = document.getElementById("fileList");
  fileList.innerHTML = "";

  if (error) {
    console.error("List error:", error.message);
    return;
  }

  data.forEach((file) => {
    const { publicUrl } = supabase.storage
      .from(BUCKET_NAME)
      .getPublicUrl(file.name).data;
    fileList.innerHTML += `<li><a href="${publicUrl}" target="_blank">${file.name}</a></li>`;
  });
}

listFiles();
